          
 pcl_file="S4000_FlankerFishv7.pcl";  
 
 
 scenario = "FlankerFish_no_feedback";
 scenario_type = trials;
 
 response_matching = simple_matching;
 response_logging = log_active;
 default_all_responses = false; 
 default_trial_duration = 4000;
 default_trial_type = first_response;
 default_trial_start_delay = 0;    
 
 active_buttons = 5;
 button_codes = 1,2,3,4,5;
 target_button_codes = 1,2,3,4,5;  
 
 default_background_color = 255,255,255;  
 default_text_color = 0,0,0;
 default_font_size = 25;
 
 
 begin;
 
         

#BITMAPS
bitmap { filename = "leftbutton.bmp"; } leftbutton;
bitmap { filename = "rightbutton.bmp"; } rightbutton;
bitmap { filename = "pinkfishright.bmp"; } pinkfish;
bitmap { filename = "bluefishleft.bmp"; } bluefish;

#WAVEFILES

wavefile { filename = "yes.wav"; } yes1;
wavefile { filename = "yummy.wav"; } yes2;
wavefile { filename = "excellent.wav"; } yes3;
wavefile { filename = "yipee.wav"; } yes4;
wavefile { filename = "thankyou.wav"; } yes5;
wavefile { filename = "yahoo.wav"; } yes6;
wavefile { filename = "cool.wav"; } yes7;
wavefile { filename = "yeeha.wav"; } yes8;
wavefile { filename = "oops.wav"; } no;

#SOUNDS
sound { wavefile yes1; } pass1;
sound { wavefile yes2; } pass2;
sound { wavefile yes3; } pass3;
sound { wavefile yes4; } pass4;
sound { wavefile yes5; } pass5;
sound { wavefile yes6; } pass6;
sound { wavefile yes7; } pass7;
sound { wavefile yes8; } pass8;
sound { wavefile no; } fail;

#Sounds muffled
sound { wavefile yes1; attenuation = 1;} muffled_pass1;
sound { wavefile yes2; attenuation = 1;} muffled_pass2;
sound { wavefile yes3; attenuation = 1;} muffled_pass3;
sound { wavefile yes4; attenuation = 1;} muffled_pass4;
sound { wavefile yes5; attenuation = 1;} muffled_pass5;
sound { wavefile yes6; attenuation = 1;} muffled_pass6;
sound { wavefile yes7; attenuation = 1;} muffled_pass7;
sound { wavefile yes8; attenuation = 1;} muffled_pass8;
sound { wavefile no; attenuation = 1;} muffled_fail;

 # picture definitions    
picture {
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} default;

picture {
	text {
		system_memory = true;  
		font_size=25; caption="Done?";
		};
	x = 0; y = 0;
} contP;

picture {
	text {
		system_memory = true;  
		font_size=25; caption="Do you want to leave the game?\n Press Y \n otherwise to continue on press N";
		};
	x = 0; y = 0;
} leaveP;


picture {
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} fixationIn;     

picture {

	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} fixationOut;

picture {
	bitmap { filename = "LLLLL_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_con_LP;      

picture {
	bitmap { filename = "LLLLL_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_con_LBP; 

picture {
	bitmap { filename = "RRRRR_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_con_RP; 

picture {
	bitmap { filename = "RRRRR_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_con_RBP; 

picture {
	bitmap { filename = "RRLRR_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_inc_LP; 

picture {
	bitmap { filename = "RRLRR_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_inc_LBP; 


picture {
	bitmap { filename = "LLRLL_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_inc_RP; 

picture {
	bitmap { filename = "LLRLL_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_inc_RBP; 

picture {
	bitmap { filename = "00L00_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_nod_LP; 

picture {
	bitmap { filename = "00L00_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_nod_LBP;

picture {
	bitmap { filename = "00R00_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_nod_RP; 

picture {
	bitmap { filename = "00R00_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_nod_RBP;

picture {
	bitmap { filename = "11L11_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_neu_LP; 

picture {
	bitmap { filename = "11L11_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_neu_LBP;

picture {
	bitmap { filename = "11R11_IN.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_neu_RP; 

picture {
	bitmap { filename = "11R11_INb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}blue_neu_RBP;


picture {
	bitmap { filename = "LLLLL_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_con_LP; 

picture {
	bitmap { filename = "LLLLL_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_con_LBP; 

picture {
	bitmap { filename = "RRRRR_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_con_RP; 

picture {
	bitmap { filename = "RRRRR_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_con_RBP; 


picture {
	bitmap { filename = "LLRLL_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_inc_LP; 

picture {
	bitmap { filename = "LLRLL_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_inc_LBP; 


picture {
	bitmap { filename = "RRLRR_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_inc_RP; 

picture {
	bitmap { filename = "RRLRR_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_inc_RBP; 

picture {
	bitmap { filename = "LL0LL_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_nod_LP; 

picture {
	bitmap { filename = "LL0LL_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_nod_LBP; 

picture {
	bitmap { filename = "RR0RR_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_nod_RP; 

picture {
	bitmap { filename = "RR0RR_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_nod_RBP; 

picture {
	bitmap { filename = "LL1LL_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_neu_LP; 

picture {
	bitmap { filename = "LL1LL_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_neu_LBP; 

picture {
	bitmap { filename = "RR1RR_OUT.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_neu_RP; 

picture {
	bitmap { filename = "RR1RR_OUTb.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
}pink_neu_RBP; 

 picture {text {system_memory = true;  font_size=15; caption=" ";} input_text;	x=0; y=0;} input_number;       
 
 #Instructions
picture {
	text {caption = "In this game,\n you're going to see lots of fish \n like these! \n Your job is to feed the hungry fish!"; }; 
   x = 0; y = 250;
	bitmap {filename = "RRLRR_IN.bmp";};
	x = 0; y = 100;
	bitmap {filename = "LLRLL_OUT.bmp";};
	x = 0; y = -100;
	
		
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} pictureslikethis;   

picture {

	text { caption = "When the fish are BLUE \n the hungry fish is in the MIDDLE!  \n\n Feed the MIDDLE fish \n by pressing where it's facing. \n \n Here,the middle fish is facing this way!";};             
	x = 0; y = 250;
			
	bitmap{filename = "bluedemo.bmp";};
	x = 0; y = -50;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} whenblue;    

picture {

	text { caption = "Sometimes the MIDDLE fish will be all by himself! \n You should still press where he's facing!";};             
	x = 0; y = 300;
			
	bitmap{filename = "00R00_IN.bmp";};
	x = 0; y = 200;
	
	text { caption = "Sometimes the MIDDLE fish will have company \n that's going in another direction! \n You should still press where the middle fish is facing!";};             
	x = 0; y = 100;
			
	bitmap{filename = "11L11_IN.bmp";};
	x = 0; y = -50;
	
	text { caption = "Your job is to feed the MIDDLE fish!";};             
	x = 0; y = -150;
	
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} whenblue2;

picture {
	text { caption = "Let's practice!";};             
	x = 0; y = 200;

	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} practiceblue;     

picture {
	text {caption = "Sometimes there won't be a middle fish! \n You should still press where the OUTSIDE fish are facing!";};             
	x = 0; y = 300;
	
	bitmap{filename = "RR0RR_OUT.bmp";};
	x = 0; y = 200;
	
	text {caption = "And sometimes the other fish will be going somewhere else! \n You should still press where the OUTSIDE fish are facing!";};             
	x = 0; y = 100;
	
	bitmap{filename = "LL1LL_OUT.bmp";};
	x = 0; y = -50;

	text {caption = "Your job is to feed the OUTSIDE fish!";};             
	x = 0; y = -150;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} whenpink2;    

picture {
	text {caption = "When the fish are PINK \n all the OUTSIDE fish are hungry!  \n\n Feed the fish on the OUTSIDE \n by pressing where they're facing. \n\n Here,the outside fish are facing this way!";};             
	x = 0; y = 250;
	
	bitmap{filename = "pinkdemo.bmp";};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} whenpink;    

picture {
	text { caption = "Let's practice!";};             
	x = 0; y = 200;

	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} practicepink;   
    
picture {
	text { 	background_color = 113,167,255; caption = "Blue means feed the MIDDLE! \n Press where the MIDDLE fish is facing!";};             
	x = 0; y = 300;
	bitmap bluefish;
	x = 0; y = 200;
	
	text {	background_color = 255,102,153; caption = "Pink means feed the OUTSIDE! \n Press where the OUTSIDE fish are facing!";};   
	x = 0; y = 100;
	bitmap pinkfish;
	x = 0; y = 0;
	
	text { 	background_color = 113,167,255; caption = "Blue - MIDDLE!";};             
	x = 0; y = -150;
	
	text {	background_color = 255,102,153; caption = "Pink - OUTSIDE!";};   
	x = 0; y = -200;


	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} bothrules;  
                    
picture { text { caption = "Remember...";};             x = 0; y = 0;} rememberblue;
picture { text { caption = "Remember...";};              x = 0; y = 0;} rememberpink;

picture {

	text {
		system_memory = true;  
		font_size=30; 
		caption="Nice job!! \n Now it's time to play the game for real!";
		};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} passblue;

picture {
	text {
		system_memory = true;  
		font_size=30; 
		caption="Great!! \n Now it's time to play the game for real!";
		};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} passpink;

picture {
	text {
		system_memory = true;  
		font_size=30; 
		caption="Great job!! \n \n Now a new rule!";
		};
	x = 0; y = 0;

	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} finishblue;

picture {
	text {
		system_memory = true;  
		font_size=30; 
		caption="That was wonderful!";
		};
	x = 0; y = 0;
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} finishpink;

picture {
	text {
		system_memory = true;  
		font_size=30; 
		caption="Now you're going to play the game with BOTH colors. \n So try really hard to remember the rules!";
		};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} bothcolors;

picture {
	text {
		system_memory = true;  
		font_size=30; 
		caption="Let's practice!";
		};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;	
} timetopractice;

picture {
	text {
		system_memory = true;  
		font_size=30; 
		caption="Nice! Now it's time to play the game for real!";
		};
	x = 0; y = 0;
	
	bitmap leftbutton;
   x = -300; y = -325;
   bitmap rightbutton;
   x = 300; y = -325;
} mixforreal;

  
      
   # trial definitions      
   

trial {
	trial_type = fixed;
	trial_duration = 6000;
   video {
      filename = "done.avi"; # relative to default_path
      height = 1226; width = 1508;

   };

}done;

      
trial {    
	trial_type = fixed;
   trial_duration = 500;
   picture fixationIn; 
   time = 0;  
} blue_Fix;

trial {    
	trial_type = fixed;
   trial_duration = 500;  
   picture fixationOut; 
   time = 0;  
} pink_Fix;
   
 trial {
   all_responses = true;
	trial_type = specific_response;
	trial_duration = forever;
	terminator_button = 3,4;	
	picture contP;	
	time = 0;
} cont;

 trial {
   all_responses = true;
	trial_type = specific_response;
	trial_duration = forever;
	terminator_button = 3,4;	
	picture leaveP;	
	time = 0;
} leave;


 
 # Displays a blank screen
 trial {                                    
    all_responses = true;
    trial_type = specific_response;     # trial ends when response button
    trial_duration = 4000;           # 3 is pressed
    terminator_button = 2; 
    picture default;     
    time = 0;
 }Pause;   
   
 #Intro
 trial {
    all_responses = true;                  
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   pictureslikethis; 
    time = 0;  
 }i1;    
 
 

	trial {    
		trial_type = fixed;
		trial_duration = 500;  
		picture default; 
		time = 0;  
	} Fix;
   
 
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 1;
    picture  whenblue; 
    code = "1-DEMO";
    time = 0;  
 }ifblue;
 
  trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture  whenblue2; 
    code = "1-DEMO";
    time = 0;  
 }ifblue2;
                         
                        
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   practiceblue; 
    time = 0;  
 }bluepract;
             
             
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   rememberblue; 
    time = 0;  
 }failblue;   
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 1;
    picture   whenpink; 
    code = "2-DEMO";
    time = 0;  
 }ifpink;      
 
trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   whenpink2; 
    code = "2-DEMO";
    time = 0;  
 }ifpink2; 
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   practicepink; 
    time = 0;  
 }pinkpract;
  
 
 
  trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   rememberpink; 
    time = 0;  
 }failpink;
 
trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   bothrules; 
    time = 0;  
 }rememberboth;
 
 
trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   passblue; 
    time = 0;  
 }passblueT;
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   passpink; 
    time = 0;  
 }passpinkT;
 
  trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   finishblue; 
    time = 0;  
 }finishblueT;

trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   finishpink; 
    time = 0;  
 }finishpinkT;
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   bothcolors; 
    time = 0;  
 }bothcolorsT;
 
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   timetopractice; 
    time = 0;  
 }timetopracticeT;
 
 trial {
    all_responses = true;                   
    trial_type = specific_response; 
    trial_duration = forever; 
    terminator_button = 2;
    picture   mixforreal; 
    time = 0;  
 }mixforrealT;
 
#Feedback sounds 

trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  sound fail;} wrong;
 
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_con_RBP; time = 0; sound pass1; } blue_con_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_con_LBP; time = 0; sound pass2; } blue_con_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_inc_RBP; time = 0; sound pass3; } blue_inc_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_inc_LBP; time = 0; sound pass4; } blue_inc_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_nod_RBP; time = 0; sound pass5; } blue_nod_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_nod_LBP; time = 0; sound pass6; } blue_nod_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_neu_RBP; time = 0; sound pass7; } blue_neu_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_neu_LBP; time = 0; sound pass8; } blue_neu_L_OK;

trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_con_RBP; time = 0; sound pass1; } pink_con_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_con_LBP; time = 0; sound pass2; } pink_con_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_inc_RBP; time = 0; sound pass3; } pink_inc_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_inc_LBP; time = 0; sound pass4; } pink_inc_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_nod_RBP; time = 0; sound pass5; } pink_nod_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_nod_LBP; time = 0; sound pass6; } pink_nod_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_neu_RBP; time = 0; sound pass7; } pink_neu_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_neu_LBP; time = 0; sound pass8; } pink_neu_L_OK;
    
#Feedback sounds muffled

trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  sound muffled_fail;} muffled_wrong;
 
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_con_RBP; time = 0; sound muffled_pass1; } muffled_blue_con_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_con_LBP; time = 0; sound muffled_pass2; } muffled_blue_con_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_inc_RBP; time = 0; sound muffled_pass3; } muffled_blue_inc_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_inc_LBP; time = 0; sound muffled_pass4; } muffled_blue_inc_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_nod_RBP; time = 0; sound muffled_pass5; } muffled_blue_nod_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_nod_LBP; time = 0; sound muffled_pass6; } muffled_blue_nod_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_neu_RBP; time = 0; sound muffled_pass7; } muffled_blue_neu_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture blue_neu_LBP; time = 0; sound muffled_pass8; } muffled_blue_neu_L_OK;

trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_con_RBP; time = 0; sound muffled_pass1; } muffled_pink_con_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_con_LBP; time = 0; sound muffled_pass2; } muffled_pink_con_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_inc_RBP; time = 0; sound muffled_pass3; } muffled_pink_inc_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_inc_LBP; time = 0; sound muffled_pass4; } muffled_pink_inc_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_nod_RBP; time = 0; sound muffled_pass5; } muffled_pink_nod_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_nod_LBP; time = 0; sound muffled_pass6; } muffled_pink_nod_L_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_neu_RBP; time = 0; sound muffled_pass7; } muffled_pink_neu_R_OK;
trial {all_responses = true; trial_type = fixed; trial_duration = 4000;  picture pink_neu_LBP; time = 0; sound muffled_pass8; } muffled_pink_neu_L_OK;

    
    
 ## PRACTICE
trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
   picture blue_con_RP; time = 0; code = "2-0,PRACTICE_conblue_R,1,1,2";} demo_blue_con_R;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
   picture blue_con_LP; time = 0; code = "1-0,PRACTICE_conblue_L,1,1,1";} demo_blue_con_L;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
   picture blue_inc_RP; time = 0; code = "2-0,PRACTICE_incblue_R,2,1,2";} demo_blue_inc_R;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
	picture blue_inc_LP;  time = 0; code = "1-0,PRACTICE_incblue_L,2,1,1";} demo_blue_inc_L;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
   picture blue_nod_RP; time = 0; code = "2-0,PRACTICE_nodblue_R,3,1,2";} demo_blue_nod_R;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
	picture blue_nod_LP;  time = 0; code = "1-0,PRACTICE_nodblue_L,3,1,1";} demo_blue_nod_L;
	
trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
	picture blue_neu_RP; time = 0; code = "2-0,PRACTICE_neublue_R,4,1,2";} demo_blue_neu_R;

trial {all_responses = true; 	trial_type = specific_response; 	trial_duration = forever; 	terminator_button = 1;
	picture blue_neu_LP;  time = 0; 	code = "1-0,PRACTICE_neublue_L,4,1,1";} demo_blue_neu_L;


trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
  picture pink_con_RP; target_button = 2; time = 0; code = "2-0,PRACTICE_conpink_R,1,2,2";}demo_pink_con_R;
  
trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
  picture pink_con_LP;  target_button = 1; time = 0; code = "1-0,PRACTICE_conpink_L,1,2,1";}demo_pink_con_L;
  
trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
  picture pink_inc_RP; target_button = 2; time = 0; code = "2-0,PRACTICE_incpink_R,2,2,2";}demo_pink_inc_R;
  
trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
  picture pink_inc_LP; target_button = 1; time = 0; code = "1-0,PRACTICE_incpink_L,2,2,1";}demo_pink_inc_L;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
   picture pink_nod_RP; time = 0; code = "2-0,PRACTICE_nodpink_R,3,2,2";} demo_pink_nod_R;

trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
	picture pink_nod_LP;  time = 0; code = "1-0,PRACTICE_nodpink_L,3,2,1";} demo_pink_nod_L;
	
trial {all_responses = true; trial_type = specific_response; trial_duration = forever; terminator_button = 1;
	picture pink_neu_RP; time = 0; code = "2-0,PRACTICE_neupink_R,4,2,2";} demo_pink_neu_R;

trial {all_responses = true; 	trial_type = specific_response; 	trial_duration = forever; 	terminator_button = 1;
	picture pink_neu_LP;  time = 0; 	code = "1-0,PRACTICE_neupink_L,4,2,1";} demo_pink_neu_L;
 
 ###########
 
 # Start

 
 #(blue = inside)
 trial { picture   blue_con_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,conblue_R,1,1,2";} blue_con_R;
 trial { picture   blue_con_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,conblue_L,1,1,1";} blue_con_L;  
 trial { picture   blue_inc_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,incblue_R,2,1,2";} blue_inc_R;
 trial { picture   blue_inc_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,incblue_L,2,1,1";} blue_inc_L;     
 trial { picture   blue_nod_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,nodblue_R,3,1,2";} blue_nod_R;
 trial { picture   blue_nod_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,nodblue_L,3,1,1";} blue_nod_L;  
 trial { picture   blue_neu_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,neublue_R,4,1,2";} blue_neu_R;
 trial { picture   blue_neu_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,neublue_L,4,1,1";} blue_neu_L;     
  
    
 #(pink = outside)
 trial { picture   pink_con_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,conpink_R,1,2,2";} pink_con_R;
 trial { picture   pink_con_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,conpink_L,1,2,1";} pink_con_L;       
 trial { picture   pink_inc_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,incpink_R,2,2,2";} pink_inc_R;
 trial { picture   pink_inc_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,incpink_L,2,2,1";} pink_inc_L;                               
 trial { picture   pink_nod_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,nodpink_R,3,2,2";} pink_nod_R;
 trial { picture   pink_nod_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,nodpink_L,3,2,1";} pink_nod_L;       
 trial { picture   pink_neu_RP; time = 0; stimulus_time_out = 4000; target_button = 2;  code = "2-1,neupink_R,4,2,2";} pink_neu_R;
 trial { picture   pink_neu_LP; time = 0; stimulus_time_out = 4000; target_button = 1;  code = "1-1,neupink_L,4,2,1";} pink_neu_L;   







array{
	trial demo_blue_inc_L;
	trial demo_blue_con_R;
	trial demo_blue_inc_R;
	trial demo_blue_inc_L;
} practicein1;

array{
	trial blue_inc_L_OK;
	trial blue_con_R_OK;
	trial blue_inc_R_OK;
	trial blue_inc_L_OK;
} practicein1OK;

array{
	trial demo_blue_inc_L;
	trial demo_blue_neu_R;
	trial demo_blue_inc_L;
	trial demo_blue_inc_R;
} practicein2;

array{
	trial blue_inc_L_OK;
	trial blue_neu_R_OK;
	trial blue_inc_L_OK;
	trial blue_inc_R_OK;
} practicein2OK;

array{
	trial demo_blue_inc_R;
	trial demo_blue_inc_L;
	trial demo_blue_nod_L;
	trial demo_blue_con_R;
} practicein3;

array{
	trial blue_inc_R_OK;
	trial blue_inc_L_OK;
	trial blue_nod_L_OK;
	trial blue_con_R_OK;
} practicein3OK;

array{
	trial demo_pink_inc_R;
	trial demo_pink_inc_L;
	trial demo_pink_nod_L;
	trial demo_pink_inc_R;
} practiceout1;

array{
	trial pink_inc_R_OK;
	trial pink_inc_L_OK;
	trial pink_nod_L_OK;
	trial pink_inc_R_OK;
} practiceout1OK;

array{
	trial demo_pink_con_L;
	trial demo_pink_inc_R;
	trial demo_pink_nod_L;
	trial demo_pink_inc_R;
} practiceout2;

array{
	trial pink_con_L_OK;
	trial pink_inc_R_OK;
	trial pink_nod_L_OK;
	trial pink_inc_R_OK;
} practiceout2OK;

array{
	trial demo_pink_inc_L;
	trial demo_pink_con_R;	
	trial demo_pink_inc_R;
	trial demo_pink_inc_L;
} practiceout3;

array{
	trial pink_inc_L_OK;
	trial pink_con_R_OK;	
	trial pink_inc_R_OK;
	trial pink_inc_L_OK;
} practiceout3OK;

array{
	trial demo_pink_inc_R;
	trial demo_blue_inc_R;
	trial demo_pink_inc_L;
	trial demo_blue_con_R;
	trial demo_pink_inc_R;
	trial demo_pink_con_L;
	trial demo_blue_inc_L;
	trial demo_blue_neu_L;
} practicemixed1;

array{
	trial pink_inc_R_OK;
	trial blue_inc_R_OK;
	trial pink_inc_L_OK;
	trial blue_con_R_OK;
	trial pink_inc_R_OK;
	trial pink_con_L_OK;
	trial blue_inc_L_OK;
	trial blue_neu_L_OK;
} practicemixed1OK;

array{
	trial pink_Fix;
	trial blue_Fix;
	trial pink_Fix;
	trial blue_Fix;
	trial pink_Fix;
	trial pink_Fix;
	trial blue_Fix;
	trial blue_Fix;
} practicemixedfix1;



array{
	trial demo_blue_inc_L;
	trial demo_blue_inc_L;
	trial demo_blue_con_R;	
	trial demo_pink_inc_R;	
	trial demo_pink_inc_L;
	trial demo_pink_neu_L;
	trial demo_blue_inc_R;	
	trial demo_pink_con_R;	
} practicemixed2;

array{
	trial blue_inc_L_OK;
	trial blue_inc_L_OK;
	trial blue_con_R_OK;	
	trial pink_inc_R_OK;	
	trial pink_inc_L_OK;
	trial pink_neu_L_OK;
	trial blue_inc_R_OK;	
	trial pink_con_R_OK;	
} practicemixed2OK;

array{
	trial blue_Fix;
	trial blue_Fix;
	trial blue_Fix;	
	trial pink_Fix;	
	trial pink_Fix;
	trial pink_Fix;
	trial blue_Fix;	
	trial pink_Fix;	
} practicemixedfix2;

array{
	trial demo_blue_inc_R;
	trial demo_blue_inc_R;
	trial demo_blue_con_L;	
	trial demo_pink_inc_L;	
	trial demo_pink_nod_L;
	trial demo_pink_inc_R;
	trial demo_blue_inc_L;	
	trial demo_pink_inc_R;	
} practicemixed3;

array{
	trial blue_inc_R_OK;
	trial blue_inc_R_OK;
	trial blue_con_L_OK;	
	trial pink_inc_L_OK;	
	trial pink_nod_L_OK;
	trial pink_inc_R_OK;
	trial blue_inc_L_OK;	
	trial pink_inc_R_OK;	
} practicemixed3OK;

array{
	trial blue_Fix;
	trial blue_Fix;
	trial blue_Fix;	
	trial pink_Fix;	
	trial pink_Fix;
	trial pink_Fix;
	trial blue_Fix;	
	trial pink_Fix;	
} practicemixedfix3;



array {
	trial blue_con_R;
	trial blue_inc_R;
	trial blue_nod_R;
	trial blue_inc_L;
	trial blue_inc_L;
	trial blue_con_R;
	trial blue_neu_L;
	trial blue_inc_L;
	trial blue_nod_L;
	trial blue_inc_R;
	trial blue_inc_L;
	trial blue_neu_R;
	trial blue_inc_R;
	trial blue_con_L;
	trial blue_inc_R;
	trial blue_inc_R;
	trial blue_inc_L;
}intrials;

array {
	trial blue_con_R_OK;
	trial blue_inc_R_OK;
	trial blue_nod_R_OK;
	trial blue_inc_L_OK;
	trial blue_inc_L_OK;
	trial blue_con_R_OK;
	trial blue_neu_L_OK;
	trial blue_inc_L_OK;
	trial blue_nod_L_OK;
	trial blue_inc_R_OK;
	trial blue_inc_L_OK;
	trial blue_neu_R_OK;
	trial blue_inc_R_OK;
	trial blue_con_L_OK;
	trial blue_inc_R_OK;
	trial blue_inc_R_OK;
	trial blue_inc_L_OK;
}intrialsOK;

array{
	trial pink_con_R;
	trial pink_inc_R;
	trial pink_inc_L;
	trial pink_inc_L;
	trial pink_con_R;
	trial pink_inc_L;
	trial pink_neu_L;
	trial pink_inc_R;
	trial pink_inc_L;
	trial pink_nod_R;
	trial pink_inc_R;
	trial pink_neu_R;
	trial pink_con_L;
	trial pink_inc_R;
	trial pink_inc_R;
	trial pink_nod_L;
	trial pink_inc_L;
}outtrials;

array{
	trial pink_con_R_OK;
	trial pink_inc_R_OK;
	trial pink_inc_L_OK;
	trial pink_inc_L_OK;
	trial pink_con_R_OK;
	trial pink_inc_L_OK;
	trial pink_neu_L_OK;
	trial pink_inc_R_OK;
	trial pink_inc_L_OK;
	trial pink_nod_R_OK;
	trial pink_inc_R_OK;
	trial pink_neu_R_OK;
	trial pink_con_L_OK;
	trial pink_inc_R_OK;
	trial pink_inc_R_OK;
	trial pink_nod_L_OK;
	trial pink_inc_L_OK;
}outtrialsOK;




array {
	trial pink_neu_R;
	trial blue_nod_L;
	trial pink_con_L;
	trial pink_neu_L;
	trial pink_inc_R;
	trial blue_neu_R;
	trial blue_nod_R;
	trial blue_nod_L;
	trial pink_inc_L;
	trial pink_nod_R;
	trial pink_con_R;
	trial blue_inc_L;
	trial blue_con_L;
	trial pink_inc_R;
	trial pink_nod_L;
	trial pink_neu_R;
	trial blue_inc_R;
	trial blue_nod_R;
	trial pink_inc_L;
	trial pink_inc_L;
	trial blue_con_R;
	trial blue_con_L;
	trial blue_neu_L;
	trial pink_con_R;
	trial pink_inc_R;
	trial pink_inc_L;
	trial blue_inc_R;
	trial blue_con_R;
	trial blue_neu_L;
	trial pink_con_L;
	trial pink_con_R;
	trial pink_con_L;
	trial blue_inc_L;
	trial blue_inc_L;
	trial pink_neu_R;
	trial blue_con_R;
	trial blue_inc_R;
	trial pink_nod_L;
	trial blue_neu_R;
	trial pink_inc_R;
	trial pink_nod_R;
	trial blue_con_L;
	trial blue_inc_R;
	trial blue_inc_L;
	trial pink_neu_L;
} mixedtrials;

array {
	trial pink_neu_R_OK;
	trial blue_nod_L_OK;
	trial pink_con_L_OK;
	trial pink_neu_L_OK;
	trial pink_inc_R_OK;
	trial blue_neu_R_OK;
	trial blue_nod_R_OK;
	trial blue_nod_L_OK;
	trial pink_inc_L_OK;
	trial pink_nod_R_OK;
	trial pink_con_R_OK;
	trial blue_inc_L_OK;
	trial blue_con_L_OK;
	trial pink_inc_R_OK;
	trial pink_nod_L_OK;
	trial pink_neu_R_OK;
	trial blue_inc_R_OK;
	trial blue_nod_R_OK;
	trial pink_inc_L_OK;
	trial pink_inc_L_OK;
	trial blue_con_R_OK;
	trial blue_con_L_OK;
	trial blue_neu_L_OK;
	trial pink_con_R_OK;
	trial pink_inc_R_OK;
	trial pink_inc_L_OK;
	trial blue_inc_R_OK;
	trial blue_con_R_OK;
	trial blue_neu_L_OK;
	trial pink_con_L_OK;
	trial pink_con_R_OK;
	trial pink_con_L_OK;
	trial blue_inc_L_OK;
	trial blue_inc_L_OK;
	trial pink_neu_R_OK;
	trial blue_con_R_OK;
	trial blue_inc_R_OK;
	trial pink_nod_L_OK;
	trial blue_neu_R_OK;
	trial pink_inc_R_OK;
	trial pink_nod_R_OK;
	trial blue_con_L_OK;
	trial blue_inc_R_OK;
	trial blue_inc_L_OK;
	trial pink_neu_L_OK;
} mixedtrialsOK;


####arrays below must match arrays above####

array {
	trial muffled_blue_con_R_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_nod_R_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_blue_con_R_OK;
	trial muffled_blue_neu_L_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_blue_nod_L_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_blue_neu_R_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_con_L_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_inc_L_OK;
} muffledintrialsOK; #feedback sound turned off


array{
	trial muffled_pink_con_R_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_pink_con_R_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_pink_neu_L_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_pink_nod_R_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_neu_R_OK;
	trial muffled_pink_con_L_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_nod_L_OK;
	trial muffled_pink_inc_L_OK;
} muffledouttrialsOK; #feedback sound turned off

array {
	trial muffled_pink_neu_R_OK;
	trial muffled_blue_nod_L_OK;
	trial muffled_pink_con_L_OK;
	trial muffled_pink_neu_L_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_blue_neu_R_OK;
	trial muffled_blue_nod_R_OK;
	trial muffled_blue_nod_L_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_pink_nod_R_OK;
	trial muffled_pink_con_R_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_blue_con_L_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_nod_L_OK;
	trial muffled_pink_neu_R_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_nod_R_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_blue_con_R_OK;
	trial muffled_blue_con_L_OK;
	trial muffled_blue_neu_L_OK;
	trial muffled_pink_con_R_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_inc_L_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_con_R_OK;
	trial muffled_blue_neu_L_OK;
	trial muffled_pink_con_L_OK;
	trial muffled_pink_con_R_OK;
	trial muffled_pink_con_L_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_pink_neu_R_OK;
	trial muffled_blue_con_R_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_pink_nod_L_OK;
	trial muffled_blue_neu_R_OK;
	trial muffled_pink_inc_R_OK;
	trial muffled_pink_nod_R_OK;
	trial muffled_blue_con_L_OK;
	trial muffled_blue_inc_R_OK;
	trial muffled_blue_inc_L_OK;
	trial muffled_pink_neu_L_OK;
} muffledmixedtrialsOK; #feedback sound turned off


